/*
 * Decompiled with CFR 0.152.
 */
package com.csdcorp.speech_to_text;

import android.annotation.TargetApi;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.speech.RecognitionListener;
import android.speech.RecognitionSupport;
import android.speech.RecognitionSupportCallback;
import android.speech.RecognizerIntent;
import android.speech.SpeechRecognizer;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.csdcorp.speech_to_text.ChannelResultWrapper;
import com.csdcorp.speech_to_text.LanguageDetailsChecker;
import com.csdcorp.speech_to_text.ListenMode;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.embedding.engine.plugins.activity.ActivityAware;
import io.flutter.embedding.engine.plugins.activity.ActivityPluginBinding;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0002J\b\u0010A\u001a\u00020?H\u0002J\u0010\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020\fH\u0002J\u0010\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020\u001aH\u0002J\b\u0010F\u001a\u00020?H\u0002J\u0010\u0010G\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0002J\u0010\u0010H\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0002J\u0012\u0010I\u001a\u00020?2\b\u0010J\u001a\u0004\u0018\u000100H\u0002J\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020\fH\u0002J\b\u0010M\u001a\u00020\fH\u0002J\b\u0010N\u001a\u00020\fH\u0002J\b\u0010O\u001a\u00020\fH\u0002J\u0010\u0010P\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0002J\u0010\u0010Q\u001a\u00020?2\u0006\u0010R\u001a\u00020\fH\u0002J\u0010\u0010S\u001a\u00020?2\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020?2\u0006\u0010W\u001a\u0002002\u0006\u0010X\u001a\u00020YH\u0002J\u0012\u0010V\u001a\u00020?2\b\b\u0001\u0010Z\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020?H\u0016J\u0012\u0010]\u001a\u00020?2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\b\u0010`\u001a\u00020?H\u0016J\b\u0010a\u001a\u00020?H\u0016J\u0012\u0010b\u001a\u00020?2\b\b\u0001\u0010T\u001a\u00020[H\u0016J\b\u0010c\u001a\u00020?H\u0016J\u0010\u0010d\u001a\u00020?2\u0006\u0010e\u001a\u00020\u0013H\u0016J\u001a\u0010f\u001a\u00020?2\u0006\u0010^\u001a\u00020\u00132\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u001c\u0010i\u001a\u00020?2\b\b\u0001\u0010j\u001a\u00020k2\b\b\u0001\u0010l\u001a\u00020\nH\u0016J\u0012\u0010m\u001a\u00020?2\b\u0010n\u001a\u0004\u0018\u00010hH\u0016J\u0012\u0010o\u001a\u00020?2\b\u0010^\u001a\u0004\u0018\u00010hH\u0016J\u0010\u0010p\u001a\u00020?2\u0006\u0010T\u001a\u00020UH\u0016J-\u0010q\u001a\u00020\f2\u0006\u0010r\u001a\u00020\u00132\u000e\u0010s\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0t2\u0006\u0010u\u001a\u00020vH\u0016\u00a2\u0006\u0002\u0010wJ\u0012\u0010x\u001a\u00020?2\b\u0010n\u001a\u0004\u0018\u00010hH\u0016J\u0010\u0010y\u001a\u00020?2\u0006\u0010z\u001a\u00020%H\u0016J\b\u0010{\u001a\u00020?H\u0002J\b\u0010|\u001a\u00020?H\u0002J\b\u0010}\u001a\u00020\fH\u0002J\u0010\u0010~\u001a\u00020?2\u0006\u0010\u007f\u001a\u00020\u001aH\u0002J\t\u0010\u0080\u0001\u001a\u00020?H\u0002J,\u0010\u0081\u0001\u001a\u00020?2\u0007\u0010\u0082\u0001\u001a\u00020\u001a2\u0007\u0010\u0083\u0001\u001a\u00020\f2\u0007\u0010\u0084\u0001\u001a\u0002022\u0006\u0010C\u001a\u00020\fH\u0002J4\u0010\u0085\u0001\u001a\u00020?2\u0006\u0010@\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u001a2\u0007\u0010\u0083\u0001\u001a\u00020\f2\u0007\u0010\u0086\u0001\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\fH\u0002J\u0011\u0010\u0087\u0001\u001a\u00020?2\u0006\u0010@\u001a\u00020\nH\u0002J\u001c\u0010\u0088\u0001\u001a\u00020?2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010L\u001a\u00020\fH\u0002J\u0010\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001*\u000200H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lcom/csdcorp/speech_to_text/SpeechToTextPlugin;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "Landroid/speech/RecognitionListener;", "Lio/flutter/plugin/common/PluginRegistry$RequestPermissionsResultListener;", "Lio/flutter/embedding/engine/plugins/FlutterPlugin;", "Lio/flutter/embedding/engine/plugins/activity/ActivityAware;", "()V", "activeBluetooth", "Landroid/bluetooth/BluetoothDevice;", "activeResult", "Lio/flutter/plugin/common/MethodChannel$Result;", "alwaysUseStop", "", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothDisabled", "bluetoothHeadset", "Landroid/bluetooth/BluetoothHeadset;", "brokenStopSdk", "", "channel", "Lio/flutter/plugin/common/MethodChannel;", "currentActivity", "Landroid/app/Activity;", "debugLogging", "defaultLanguageTag", "", "handler", "Landroid/os/Handler;", "initializedSuccessfully", "intentLookup", "lastFinalTime", "", "lastOnDevice", "listening", "logTag", "maxRms", "", "minRms", "minSdkForOnDeviceSpeechSupport", "minSdkForSpeechSupport", "missingConfidence", "", "noBluetoothOpt", "pairedDevices", "", "permissionToRecordAudio", "pluginContext", "Landroid/content/Context;", "previousListenMode", "Lcom/csdcorp/speech_to_text/ListenMode;", "previousPartialResults", "previousRecognizerLang", "recognizerIntent", "Landroid/content/Intent;", "recognizerStops", "resultSent", "speechRecognizer", "Landroid/speech/SpeechRecognizer;", "speechStartTime", "speechThresholdRms", "speechToTextPermissionCode", "cancelListening", "", "result", "completeInitialize", "createRecognizer", "onDevice", "debugLog", "msg", "destroyRecognizer", "hasPermission", "initialize", "initializeIfPermitted", "context", "isDuplicateFinal", "isFinal", "isListening", "isNotInitialized", "isNotListening", "locales", "notifyListening", "isRecording", "onAttachedToActivity", "binding", "Lio/flutter/embedding/engine/plugins/activity/ActivityPluginBinding;", "onAttachedToEngine", "applicationContext", "messenger", "Lio/flutter/plugin/common/BinaryMessenger;", "flutterPluginBinding", "Lio/flutter/embedding/engine/plugins/FlutterPlugin$FlutterPluginBinding;", "onBeginningOfSpeech", "onBufferReceived", "p0", "", "onDetachedFromActivity", "onDetachedFromActivityForConfigChanges", "onDetachedFromEngine", "onEndOfSpeech", "onError", "errorCode", "onEvent", "p1", "Landroid/os/Bundle;", "onMethodCall", "call", "Lio/flutter/plugin/common/MethodCall;", "rawrResult", "onPartialResults", "results", "onReadyForSpeech", "onReattachedToActivityForConfigChanges", "onRequestPermissionsResult", "requestCode", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)Z", "onResults", "onRmsChanged", "rmsdB", "optionallyStartBluetooth", "optionallyStopBluetooth", "sdkVersionTooLow", "sendError", "errorMsg", "setupBluetooth", "setupRecognizerIntent", "languageTag", "partialResults", "listenMode", "startListening", "listenModeIndex", "stopListening", "updateResults", "speechBundle", "findComponentName", "Landroid/content/ComponentName;", "speech_to_text_release"})
@TargetApi(value=8)
@SourceDebugExtension(value={"SMAP\nSpeechToTextPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeechToTextPlugin.kt\ncom/csdcorp/speech_to_text/SpeechToTextPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,844:1\n1855#2:845\n1856#2:847\n1#3:846\n*S KotlinDebug\n*F\n+ 1 SpeechToTextPlugin.kt\ncom/csdcorp/speech_to_text/SpeechToTextPlugin\n*L\n569#1:845\n569#1:847\n*E\n"})
public final class SpeechToTextPlugin
implements MethodChannel.MethodCallHandler,
RecognitionListener,
PluginRegistry.RequestPermissionsResultListener,
FlutterPlugin,
ActivityAware {
    @Nullable
    private Context pluginContext;
    @Nullable
    private MethodChannel channel;
    private final int minSdkForSpeechSupport;
    private final int brokenStopSdk;
    private final int minSdkForOnDeviceSpeechSupport;
    private final int speechToTextPermissionCode;
    private final double missingConfidence;
    private int speechThresholdRms = 9;
    @NotNull
    private final String logTag;
    private boolean recognizerStops = true;
    @Nullable
    private Activity currentActivity;
    @Nullable
    private MethodChannel.Result activeResult;
    private boolean initializedSuccessfully;
    private boolean permissionToRecordAudio;
    private boolean listening;
    private boolean debugLogging;
    private boolean alwaysUseStop;
    private boolean intentLookup;
    private boolean noBluetoothOpt;
    private boolean bluetoothDisabled = true;
    private boolean resultSent;
    private boolean lastOnDevice;
    @Nullable
    private SpeechRecognizer speechRecognizer;
    @Nullable
    private Intent recognizerIntent;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @Nullable
    private Set<BluetoothDevice> pairedDevices;
    @Nullable
    private BluetoothDevice activeBluetooth;
    @Nullable
    private BluetoothHeadset bluetoothHeadset;
    @Nullable
    private String previousRecognizerLang;
    private boolean previousPartialResults = true;
    @NotNull
    private ListenMode previousListenMode = ListenMode.deviceDefault;
    private long lastFinalTime;
    private long speechStartTime;
    private float minRms = 1000.0f;
    private float maxRms = -100.0f;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    @NotNull
    private final String defaultLanguageTag;

    public SpeechToTextPlugin() {
        this.minSdkForSpeechSupport = 21;
        this.brokenStopSdk = 29;
        this.minSdkForOnDeviceSpeechSupport = 31;
        this.speechToTextPermissionCode = 28521;
        this.missingConfidence = -1.0;
        this.logTag = "SpeechToTextPlugin";
        String string = Locale.getDefault().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefault().toLanguageTag()");
        this.defaultLanguageTag = string;
    }

    public void onAttachedToEngine(@NonNull @NotNull FlutterPlugin.FlutterPluginBinding flutterPluginBinding) {
        Intrinsics.checkNotNullParameter((Object)flutterPluginBinding, (String)"flutterPluginBinding");
        Context context = flutterPluginBinding.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"flutterPluginBinding.getApplicationContext()");
        BinaryMessenger binaryMessenger = flutterPluginBinding.getBinaryMessenger();
        Intrinsics.checkNotNullExpressionValue((Object)binaryMessenger, (String)"flutterPluginBinding.getBinaryMessenger()");
        this.onAttachedToEngine(context, binaryMessenger);
    }

    private final void onAttachedToEngine(Context applicationContext, BinaryMessenger messenger) {
        block0: {
            this.pluginContext = applicationContext;
            MethodChannel methodChannel = this.channel = new MethodChannel(messenger, "plugin.csdcorp.com/speech_to_text");
            if (methodChannel == null) break block0;
            methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        }
    }

    public void onDetachedFromEngine(@NonNull @NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.pluginContext = null;
        MethodChannel methodChannel = this.channel;
        if (methodChannel != null) {
            methodChannel.setMethodCallHandler(null);
        }
        this.channel = null;
    }

    public void onDetachedFromActivity() {
        this.currentActivity = null;
    }

    public void onReattachedToActivityForConfigChanges(@NotNull ActivityPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.currentActivity = binding.getActivity();
        binding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this);
    }

    public void onAttachedToActivity(@NotNull ActivityPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.currentActivity = binding.getActivity();
        binding.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)this);
    }

    public void onDetachedFromActivityForConfigChanges() {
        this.currentActivity = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMethodCall(@NonNull @NotNull MethodCall call, @NonNull @NotNull MethodChannel.Result rawrResult) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)rawrResult, (String)"rawrResult");
        ChannelResultWrapper result = new ChannelResultWrapper(rawrResult);
        try {
            String string = call.method;
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1367724422: {
                        if (!string.equals("cancel")) break;
                        n = 1;
                        break;
                    }
                    case 338410841: {
                        if (!string.equals("locales")) break;
                        n = 2;
                        break;
                    }
                    case -1198472044: {
                        if (!string.equals("has_permission")) break;
                        n = 3;
                        break;
                    }
                    case 3540994: {
                        if (!string.equals("stop")) break;
                        n = 4;
                        break;
                    }
                    case 871091088: {
                        if (!string.equals("initialize")) break;
                        n = 5;
                        break;
                    }
                    case -1102508601: {
                        if (!string.equals("listen")) break;
                        n = 6;
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        this.hasPermission(result);
                        return;
                    }
                    case 5: {
                        Boolean noBtOpt;
                        Boolean iOpt;
                        Boolean ausOpt;
                        Boolean dlog = (Boolean)call.argument("debugLogging");
                        if (dlog != null) {
                            this.debugLogging = dlog;
                        }
                        if ((ausOpt = (Boolean)call.argument("alwaysUseStop")) != null) {
                            this.alwaysUseStop = Intrinsics.areEqual((Object)ausOpt, (Object)true);
                        }
                        if ((iOpt = (Boolean)call.argument("intentLookup")) != null) {
                            this.intentLookup = Intrinsics.areEqual((Object)iOpt, (Object)true);
                        }
                        if ((noBtOpt = (Boolean)call.argument("noBluetooth")) != null) {
                            this.noBluetoothOpt = Intrinsics.areEqual((Object)noBtOpt, (Object)true);
                        }
                        this.initialize(result);
                        return;
                    }
                    case 6: {
                        Integer listenModeIndex;
                        Boolean onDevice;
                        String localeId = (String)call.argument("localeId");
                        if (localeId == null) {
                            localeId = this.defaultLanguageTag;
                        }
                        localeId = StringsKt.replace$default((String)localeId, (char)'_', (char)'-', (boolean)false, (int)4, null);
                        Boolean partialResults = (Boolean)call.argument("partialResults");
                        if (partialResults == null) {
                            partialResults = true;
                        }
                        if ((onDevice = (Boolean)call.argument("onDevice")) == null) {
                            onDevice = false;
                        }
                        if ((listenModeIndex = (Integer)call.argument("listenMode")) == null) {
                            result.error("missingOrInvalidArg", "listenMode is required", null);
                            return;
                        }
                        this.startListening(result, localeId, partialResults, listenModeIndex, onDevice);
                        return;
                    }
                    case 4: {
                        this.stopListening(result);
                        return;
                    }
                    case 1: {
                        this.cancelListening(result);
                        return;
                    }
                    case 2: {
                        this.locales(result);
                        return;
                    }
                }
            }
            result.notImplemented();
            return;
        }
        catch (Exception exc) {
            Log.e((String)this.logTag, (String)"Unexpected exception", (Throwable)exc);
            result.error("unknown", "Unexpected exception", exc.getLocalizedMessage());
        }
    }

    private final void hasPermission(MethodChannel.Result result) {
        if (this.sdkVersionTooLow()) {
            result.success((Object)false);
            return;
        }
        this.debugLog("Start has_permission");
        Context localContext = this.pluginContext;
        if (localContext != null) {
            boolean hasPerm = ContextCompat.checkSelfPermission((Context)localContext, (String)"android.permission.RECORD_AUDIO") == 0;
            result.success((Object)hasPerm);
        }
    }

    private final void initialize(MethodChannel.Result result) {
        if (this.sdkVersionTooLow()) {
            result.success((Object)false);
            return;
        }
        this.recognizerStops = Build.VERSION.SDK_INT != this.brokenStopSdk || this.alwaysUseStop;
        this.debugLog("Start initialize");
        if (this.activeResult != null) {
            result.error("multipleRequests", "Only one initialize at a time", null);
            return;
        }
        this.activeResult = result;
        this.initializeIfPermitted(this.pluginContext);
    }

    private final boolean sdkVersionTooLow() {
        return Build.VERSION.SDK_INT < this.minSdkForSpeechSupport;
    }

    private final boolean isNotInitialized() {
        return !this.initializedSuccessfully;
    }

    private final boolean isListening() {
        return this.listening;
    }

    private final boolean isNotListening() {
        return !this.listening;
    }

    private final void startListening(MethodChannel.Result result, String languageTag, boolean partialResults, int listenModeIndex, boolean onDevice) {
        if (this.sdkVersionTooLow() || this.isNotInitialized() || this.isListening()) {
            result.success((Object)false);
            return;
        }
        this.resultSent = false;
        this.createRecognizer(onDevice);
        this.minRms = 1000.0f;
        this.maxRms = -100.0f;
        this.debugLog("Start listening");
        ListenMode listenMode = ListenMode.deviceDefault;
        if (listenModeIndex == ListenMode.dictation.ordinal()) {
            listenMode = ListenMode.dictation;
        }
        this.optionallyStartBluetooth();
        this.setupRecognizerIntent(languageTag, partialResults, listenMode, onDevice);
        this.handler.post(() -> SpeechToTextPlugin.startListening$lambda$1(this));
        this.speechStartTime = System.currentTimeMillis();
        this.notifyListening(true);
        result.success((Object)true);
        this.debugLog("Start listening done");
    }

    private final void optionallyStartBluetooth() {
        if (this.bluetoothDisabled) {
            return;
        }
        Context context = this.pluginContext;
        BluetoothAdapter lbt = this.bluetoothAdapter;
        Set<BluetoothDevice> lpaired = this.pairedDevices;
        BluetoothHeadset lhead = this.bluetoothHeadset;
        if (lbt != null && lhead != null && lpaired != null && lbt.isEnabled()) {
            for (BluetoothDevice tryDevice : lpaired) {
                if (!lhead.startVoiceRecognition(tryDevice)) continue;
                this.debugLog("Starting bluetooth voice recognition");
                this.activeBluetooth = tryDevice;
                break;
            }
        }
    }

    private final void stopListening(MethodChannel.Result result) {
        if (this.sdkVersionTooLow() || this.isNotInitialized() || this.isNotListening()) {
            result.success((Object)false);
            return;
        }
        this.debugLog("Stop listening");
        this.handler.post(() -> SpeechToTextPlugin.stopListening$lambda$3(this));
        if (!this.recognizerStops) {
            this.destroyRecognizer();
        }
        this.notifyListening(false);
        result.success((Object)true);
        this.debugLog("Stop listening done");
    }

    private final void cancelListening(MethodChannel.Result result) {
        if (this.sdkVersionTooLow() || this.isNotInitialized() || this.isNotListening()) {
            result.success((Object)false);
            return;
        }
        this.debugLog("Cancel listening");
        this.handler.post(() -> SpeechToTextPlugin.cancelListening$lambda$5(this));
        if (!this.recognizerStops) {
            this.destroyRecognizer();
        }
        this.notifyListening(false);
        result.success((Object)true);
        this.debugLog("Cancel listening done");
    }

    private final void locales(MethodChannel.Result result) {
        block4: {
            block3: {
                boolean hasPermission;
                if (this.sdkVersionTooLow()) {
                    result.success((Object)false);
                    return;
                }
                Context context = this.pluginContext;
                Intrinsics.checkNotNull((Object)context);
                boolean bl = hasPermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
                if (Build.VERSION.SDK_INT < 33 || !hasPermission) break block3;
                Context context2 = this.pluginContext;
                Intrinsics.checkNotNull((Object)context2);
                if (!SpeechRecognizer.isOnDeviceRecognitionAvailable((Context)context2)) break block4;
                Ref.ObjectRef recognizer = new Ref.ObjectRef();
                Context context3 = this.pluginContext;
                Intrinsics.checkNotNull((Object)context3);
                SpeechRecognizer speechRecognizer = SpeechRecognizer.createOnDeviceSpeechRecognizer((Context)context3);
                Intrinsics.checkNotNullExpressionValue((Object)speechRecognizer, (String)"createOnDeviceSpeechRecognizer(pluginContext!!)");
                recognizer.element = speechRecognizer;
                Intent recognizerIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
                SpeechRecognizer speechRecognizer2 = (SpeechRecognizer)recognizer.element;
                if (speechRecognizer2 != null) {
                    speechRecognizer2.checkRecognitionSupport(recognizerIntent, (Executor)Executors.newSingleThreadExecutor(), new RecognitionSupportCallback(result, this, (Ref.ObjectRef<SpeechRecognizer>)recognizer){
                        final /* synthetic */ MethodChannel.Result $result;
                        final /* synthetic */ SpeechToTextPlugin this$0;
                        final /* synthetic */ Ref.ObjectRef<SpeechRecognizer> $recognizer;
                        {
                            this.$result = $result;
                            this.this$0 = $receiver;
                            this.$recognizer = $recognizer;
                        }

                        public void onSupportResult(@NotNull RecognitionSupport recognitionSupport) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)recognitionSupport, (String)"recognitionSupport");
                                LanguageDetailsChecker details = new LanguageDetailsChecker(this.$result, SpeechToTextPlugin.access$getDebugLogging$p(this.this$0));
                                details.createResponse(recognitionSupport.getSupportedOnDeviceLanguages());
                                SpeechRecognizer speechRecognizer = (SpeechRecognizer)this.$recognizer.element;
                                if (speechRecognizer == null) break block0;
                                speechRecognizer.destroy();
                            }
                        }

                        public void onError(int error) {
                            block0: {
                                SpeechToTextPlugin.access$debugLog(this.this$0, "error from checkRecognitionSupport: " + error);
                                SpeechRecognizer speechRecognizer = (SpeechRecognizer)this.$recognizer.element;
                                if (speechRecognizer == null) break block0;
                                speechRecognizer.destroy();
                            }
                        }
                    });
                }
                break block4;
            }
            Intent detailsIntent = RecognizerIntent.getVoiceDetailsIntent((Context)this.pluginContext);
            if (detailsIntent == null) {
                detailsIntent = new Intent("android.speech.action.GET_LANGUAGE_DETAILS");
                detailsIntent.setPackage("com.google.android.googlequicksearchbox");
            }
            Context context = this.pluginContext;
            if (context == null) break block4;
            context.sendOrderedBroadcast(detailsIntent, null, (BroadcastReceiver)new LanguageDetailsChecker(result, this.debugLogging), null, -1, null, null);
        }
    }

    private final void notifyListening(boolean isRecording) {
        block7: {
            String string;
            if (this.listening == isRecording) {
                return;
            }
            this.listening = isRecording;
            boolean bl = isRecording;
            if (bl) {
                string = "listening";
            } else if (!bl) {
                string = "notListening";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String status = string;
            this.debugLog("Notify status:" + status);
            MethodChannel methodChannel = this.channel;
            if (methodChannel != null) {
                methodChannel.invokeMethod("notifyStatus", (Object)status);
            }
            if (isRecording) break block7;
            String doneStatus = !this.resultSent ? "doneNoResult" : "done";
            this.debugLog("Notify status:" + doneStatus);
            this.optionallyStopBluetooth();
            MethodChannel methodChannel2 = this.channel;
            if (methodChannel2 != null) {
                methodChannel2.invokeMethod("notifyStatus", (Object)doneStatus);
            }
        }
    }

    private final void optionallyStopBluetooth() {
        if (this.bluetoothDisabled) {
            return;
        }
        BluetoothDevice lactive = this.activeBluetooth;
        BluetoothHeadset lbt = this.bluetoothHeadset;
        if (lactive != null && lbt != null) {
            this.debugLog("Stopping bluetooth voice recognition");
            lbt.stopVoiceRecognition(lactive);
            this.activeBluetooth = null;
        }
    }

    private final void updateResults(Bundle speechBundle, boolean isFinal) {
        ArrayList userSaid;
        if (this.isDuplicateFinal(isFinal)) {
            this.debugLog("Discarding duplicate final");
            return;
        }
        Bundle bundle = speechBundle;
        ArrayList arrayList = userSaid = bundle != null ? bundle.getStringArrayList("results_recognition") : null;
        if (userSaid != null && !((Collection)userSaid).isEmpty()) {
            JSONObject speechResult = new JSONObject();
            speechResult.put("finalResult", isFinal);
            float[] confidence = speechBundle.getFloatArray("confidence_scores");
            JSONArray alternates = new JSONArray();
            int resultIndex = 0;
            int n = userSaid.size() - 1;
            if (resultIndex <= n) {
                while (true) {
                    JSONObject speechWords = new JSONObject();
                    speechWords.put("recognizedWords", userSaid.get(resultIndex));
                    if (confidence != null && confidence.length >= userSaid.size()) {
                        speechWords.put("confidence", (Object)Float.valueOf(confidence[resultIndex]));
                    } else {
                        speechWords.put("confidence", this.missingConfidence);
                    }
                    alternates.put((Object)speechWords);
                    if (resultIndex == n) break;
                    ++resultIndex;
                }
            }
            speechResult.put("alternates", (Object)alternates);
            String string = speechResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"speechResult.toString()");
            String jsonResult = string;
            this.debugLog("Calling results callback");
            this.resultSent = true;
            MethodChannel methodChannel = this.channel;
            if (methodChannel != null) {
                methodChannel.invokeMethod("textRecognition", (Object)jsonResult);
            }
        } else {
            this.debugLog("Results null or empty");
        }
    }

    private final boolean isDuplicateFinal(boolean isFinal) {
        if (!isFinal) {
            return false;
        }
        long delta = System.currentTimeMillis() - this.lastFinalTime;
        this.lastFinalTime = System.currentTimeMillis();
        return delta >= 0L && delta < 100L;
    }

    private final void initializeIfPermitted(Context context) {
        Context localContext = context;
        if (localContext == null) {
            this.completeInitialize();
            return;
        }
        this.permissionToRecordAudio = ContextCompat.checkSelfPermission((Context)localContext, (String)"android.permission.RECORD_AUDIO") == 0;
        boolean permissionToEnableBluetooth = ContextCompat.checkSelfPermission((Context)localContext, (String)"android.permission.BLUETOOTH_CONNECT") == 0;
        this.bluetoothDisabled = !permissionToEnableBluetooth || this.noBluetoothOpt;
        this.debugLog("Checked permission");
        if (!this.permissionToRecordAudio) {
            Activity localActivity = this.currentActivity;
            if (localActivity != null) {
                this.debugLog("Requesting permission");
                Object[] objectArray = new String[]{"android.permission.RECORD_AUDIO"};
                Object[] requiredPermissions = objectArray;
                if (!this.noBluetoothOpt) {
                    requiredPermissions = (String[])ArraysKt.plus((Object[])requiredPermissions, (Object)"android.permission.BLUETOOTH_CONNECT");
                }
                ActivityCompat.requestPermissions((Activity)localActivity, (String[])requiredPermissions, (int)this.speechToTextPermissionCode);
            } else {
                this.debugLog("no permission, no activity, completing");
                this.completeInitialize();
            }
        } else {
            this.debugLog("has permission, completing");
            this.completeInitialize();
        }
        this.debugLog("leaving initializeIfPermitted");
    }

    private final void completeInitialize() {
        this.debugLog("completeInitialize");
        if (this.permissionToRecordAudio) {
            this.debugLog("Testing recognition availability");
            Context localContext = this.pluginContext;
            if (localContext != null) {
                if (Build.VERSION.SDK_INT >= 31) {
                    if (!SpeechRecognizer.isRecognitionAvailable((Context)localContext) && !SpeechRecognizer.isOnDeviceRecognitionAvailable((Context)localContext)) {
                        Log.e((String)this.logTag, (String)"Speech recognition not available on this device");
                        MethodChannel.Result result = this.activeResult;
                        if (result != null) {
                            result.error("recognizerNotAvailable", "Speech recognition not available on this device", (Object)"");
                        }
                        this.activeResult = null;
                        return;
                    }
                } else if (!SpeechRecognizer.isRecognitionAvailable((Context)localContext)) {
                    Log.e((String)this.logTag, (String)"Speech recognition not available on this device");
                    MethodChannel.Result result = this.activeResult;
                    if (result != null) {
                        result.error("recognizerNotAvailable", "Speech recognition not available on this device", (Object)"");
                    }
                    this.activeResult = null;
                    return;
                }
                this.setupBluetooth();
            } else {
                this.debugLog("null context during initialization");
                MethodChannel.Result result = this.activeResult;
                if (result != null) {
                    result.success((Object)false);
                }
                MethodChannel.Result result2 = this.activeResult;
                if (result2 != null) {
                    result2.error("missingContext", "context unexpectedly null, initialization failed", (Object)"");
                }
                this.activeResult = null;
                return;
            }
        }
        this.initializedSuccessfully = this.permissionToRecordAudio;
        this.debugLog("sending result");
        MethodChannel.Result result = this.activeResult;
        if (result != null) {
            result.success((Object)this.permissionToRecordAudio);
        }
        this.debugLog("leaving complete");
        this.activeResult = null;
    }

    private final void setupBluetooth() {
        block1: {
            if (this.bluetoothDisabled) {
                return;
            }
            BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            this.pairedDevices = bluetoothAdapter != null ? bluetoothAdapter.getBondedDevices() : null;
            BluetoothProfile.ServiceListener mProfileListener2 = new BluetoothProfile.ServiceListener(this){
                final /* synthetic */ SpeechToTextPlugin this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onServiceConnected(int profile, @NotNull BluetoothProfile proxy) {
                    Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                    if (profile == 1) {
                        SpeechToTextPlugin.access$setBluetoothHeadset$p(this.this$0, (BluetoothHeadset)proxy);
                        SpeechToTextPlugin.access$debugLog(this.this$0, "Found a headset: " + SpeechToTextPlugin.access$getBluetoothHeadset$p(this.this$0));
                    }
                }

                public void onServiceDisconnected(int profile) {
                    if (profile == 1) {
                        SpeechToTextPlugin.access$debugLog(this.this$0, "Clearing headset: ");
                        SpeechToTextPlugin.access$setBluetoothHeadset$p(this.this$0, null);
                    }
                }
            };
            BluetoothAdapter bluetoothAdapter2 = this.bluetoothAdapter;
            if (bluetoothAdapter2 == null) break block1;
            bluetoothAdapter2.getProfileProxy(this.pluginContext, mProfileListener2, 1);
        }
    }

    private final ComponentName findComponentName(Context $this$findComponentName) {
        ComponentName componentName;
        List list = $this$findComponentName.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryInte\u2026ce.SERVICE_INTERFACE), 0)");
        List list2 = list;
        this.debugLog("RecognitionService, found: " + list2.size());
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServiceInfo serviceInfo;
            ResolveInfo it = (ResolveInfo)element$iv;
            boolean bl = false;
            ServiceInfo serviceInfo2 = serviceInfo = it.serviceInfo;
            if (serviceInfo2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)serviceInfo2, (String)"serviceInfo");
            ServiceInfo it1 = serviceInfo;
            boolean bl2 = false;
            this.debugLog("RecognitionService: packageName: " + it1.packageName + ", name: " + it1.name);
        }
        ResolveInfo resolveInfo = (ResolveInfo)CollectionsKt.firstOrNull((List)list2);
        if (resolveInfo != null && (resolveInfo = resolveInfo.serviceInfo) != null) {
            ResolveInfo it = resolveInfo;
            boolean bl = false;
            componentName = new ComponentName(it.packageName, it.name);
        } else {
            componentName = null;
        }
        return componentName;
    }

    private final void createRecognizer(boolean onDevice) {
        if (this.speechRecognizer != null && onDevice == this.lastOnDevice) {
            return;
        }
        this.lastOnDevice = onDevice;
        SpeechRecognizer speechRecognizer = this.speechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.destroy();
        }
        this.speechRecognizer = null;
        this.handler.post(() -> SpeechToTextPlugin.createRecognizer$lambda$13(this, onDevice));
        this.debugLog("before setup intent");
        this.setupRecognizerIntent(this.defaultLanguageTag, true, ListenMode.deviceDefault, false);
        this.debugLog("after setup intent");
    }

    private final void setupRecognizerIntent(String languageTag, boolean partialResults, ListenMode listenMode, boolean onDevice) {
        this.debugLog("setupRecognizerIntent");
        if (this.previousRecognizerLang == null || !Intrinsics.areEqual((Object)this.previousRecognizerLang, (Object)languageTag) || partialResults != this.previousPartialResults || this.previousListenMode != listenMode) {
            this.previousRecognizerLang = languageTag;
            this.previousPartialResults = partialResults;
            this.previousListenMode = listenMode;
            this.handler.post(() -> SpeechToTextPlugin.setupRecognizerIntent$lambda$16(this, partialResults, languageTag, onDevice));
        }
    }

    private final void destroyRecognizer() {
        this.handler.postDelayed(() -> SpeechToTextPlugin.destroyRecognizer$lambda$18(this), 50L);
    }

    public boolean onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        if (requestCode == this.speechToTextPermissionCode) {
            this.permissionToRecordAudio = !(grantResults.length == 0) && grantResults[0] == 0;
            this.bluetoothDisabled = grantResults.length == 0 || grantResults.length == 1 || grantResults[1] != 0 || this.noBluetoothOpt;
            this.completeInitialize();
            return true;
        }
        return false;
    }

    public void onPartialResults(@Nullable Bundle results) {
        this.updateResults(results, false);
    }

    public void onResults(@Nullable Bundle results) {
        this.updateResults(results, true);
    }

    public void onEndOfSpeech() {
        this.notifyListening(false);
    }

    public void onError(int errorCode) {
        String string;
        long delta = System.currentTimeMillis() - this.speechStartTime;
        int errorReturn = errorCode;
        if (7 == errorCode && this.maxRms < (float)this.speechThresholdRms) {
            errorReturn = 6;
        }
        this.debugLog("Error " + errorCode + " after start at " + delta + ' ' + this.minRms + " / " + this.maxRms);
        switch (errorReturn) {
            case 3: {
                string = "error_audio_error";
                break;
            }
            case 5: {
                string = "error_client";
                break;
            }
            case 9: {
                string = "error_permission";
                break;
            }
            case 2: {
                string = "error_network";
                break;
            }
            case 1: {
                string = "error_network_timeout";
                break;
            }
            case 7: {
                string = "error_no_match";
                break;
            }
            case 8: {
                string = "error_busy";
                break;
            }
            case 4: {
                string = "error_server";
                break;
            }
            case 6: {
                string = "error_speech_timeout";
                break;
            }
            case 12: {
                string = "error_language_not_supported";
                break;
            }
            case 13: {
                string = "error_language_unavailable";
                break;
            }
            case 11: {
                string = "error_server_disconnected";
                break;
            }
            case 10: {
                string = "error_too_many_requests";
                break;
            }
            default: {
                string = "error_unknown (" + errorCode + ')';
            }
        }
        String errorMsg = string;
        this.sendError(errorMsg);
        if (this.isListening()) {
            this.notifyListening(false);
        }
    }

    private final void debugLog(String msg) {
        if (this.debugLogging) {
            Log.d((String)this.logTag, (String)msg);
        }
    }

    private final void sendError(String errorMsg) {
        JSONObject speechError = new JSONObject();
        speechError.put("errorMsg", (Object)errorMsg);
        speechError.put("permanent", true);
        this.handler.post(() -> SpeechToTextPlugin.sendError$lambda$20(this, speechError));
    }

    public void onRmsChanged(float rmsdB) {
        if (rmsdB < this.minRms) {
            this.minRms = rmsdB;
        }
        if (rmsdB > this.maxRms) {
            this.maxRms = rmsdB;
        }
        this.debugLog("rmsDB " + this.minRms + " / " + this.maxRms);
        this.handler.post(() -> SpeechToTextPlugin.onRmsChanged$lambda$22(this, rmsdB));
    }

    public void onReadyForSpeech(@Nullable Bundle p0) {
    }

    public void onBufferReceived(@Nullable byte[] p0) {
    }

    public void onEvent(int p0, @Nullable Bundle p1) {
    }

    public void onBeginningOfSpeech() {
    }

    private static final void startListening$lambda$1(SpeechToTextPlugin this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpeechToTextPlugin $this$startListening_u24lambda_u241_u24lambda_u240 = this$0;
            boolean bl = false;
            SpeechRecognizer speechRecognizer = $this$startListening_u24lambda_u241_u24lambda_u240.speechRecognizer;
            if (speechRecognizer == null) break block0;
            speechRecognizer.startListening($this$startListening_u24lambda_u241_u24lambda_u240.recognizerIntent);
        }
    }

    private static final void stopListening$lambda$3(SpeechToTextPlugin this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpeechToTextPlugin $this$stopListening_u24lambda_u243_u24lambda_u242 = this$0;
            boolean bl = false;
            SpeechRecognizer speechRecognizer = $this$stopListening_u24lambda_u243_u24lambda_u242.speechRecognizer;
            if (speechRecognizer == null) break block0;
            speechRecognizer.stopListening();
        }
    }

    private static final void cancelListening$lambda$5(SpeechToTextPlugin this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpeechToTextPlugin $this$cancelListening_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            SpeechRecognizer speechRecognizer = $this$cancelListening_u24lambda_u245_u24lambda_u244.speechRecognizer;
            if (speechRecognizer == null) break block0;
            speechRecognizer.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void createRecognizer$lambda$13(SpeechToTextPlugin this$0, boolean $onDevice) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SpeechToTextPlugin $this$createRecognizer_u24lambda_u2413_u24lambda_u2412 = this$0;
        boolean bl = false;
        $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.debugLog("Creating recognizer");
        if ($this$createRecognizer_u24lambda_u2413_u24lambda_u2412.intentLookup) {
            void $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u249;
            SpeechRecognizer speechRecognizer;
            Context context = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.pluginContext;
            SpeechRecognizer speechRecognizer2 = speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)$this$createRecognizer_u24lambda_u2413_u24lambda_u2412.pluginContext, (ComponentName)(context != null ? $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.findComponentName(context) : null));
            SpeechToTextPlugin speechToTextPlugin = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412;
            boolean bl2 = false;
            $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.debugLog("Setting listener after intent lookup");
            $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u249.setRecognitionListener((RecognitionListener)this$0);
            speechToTextPlugin.speechRecognizer = speechRecognizer;
        } else {
            SpeechRecognizer $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410;
            SpeechToTextPlugin speechToTextPlugin;
            SpeechRecognizer speechRecognizer;
            boolean supportsLocal = false;
            if (Build.VERSION.SDK_INT >= 31 && $onDevice) {
                Context context = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.pluginContext;
                Intrinsics.checkNotNull((Object)context);
                supportsLocal = SpeechRecognizer.isOnDeviceRecognitionAvailable((Context)context);
                if (supportsLocal) {
                    Context context2 = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.pluginContext;
                    Intrinsics.checkNotNull((Object)context2);
                    SpeechRecognizer bl2 = speechRecognizer = SpeechRecognizer.createOnDeviceSpeechRecognizer((Context)context2);
                    speechToTextPlugin = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412;
                    boolean bl3 = false;
                    $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.debugLog("Setting on device listener");
                    $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.setRecognitionListener((RecognitionListener)this$0);
                    speechToTextPlugin.speechRecognizer = speechRecognizer;
                }
            }
            if ($this$createRecognizer_u24lambda_u2413_u24lambda_u2412.speechRecognizer == null) {
                void $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411;
                $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410 = speechRecognizer = SpeechRecognizer.createSpeechRecognizer((Context)$this$createRecognizer_u24lambda_u2413_u24lambda_u2412.pluginContext);
                speechToTextPlugin = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412;
                boolean bl4 = false;
                $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.debugLog("Setting default listener");
                $this$createRecognizer_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.setRecognitionListener((RecognitionListener)this$0);
                speechToTextPlugin.speechRecognizer = speechRecognizer;
            }
        }
        if ($this$createRecognizer_u24lambda_u2413_u24lambda_u2412.speechRecognizer == null) {
            Log.e((String)$this$createRecognizer_u24lambda_u2413_u24lambda_u2412.logTag, (String)"Speech recognizer null");
            MethodChannel.Result result = $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.activeResult;
            if (result != null) {
                result.error("recognizerNotAvailable", "Speech recognizer null", (Object)"");
            }
            $this$createRecognizer_u24lambda_u2413_u24lambda_u2412.activeResult = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupRecognizerIntent$lambda$16(SpeechToTextPlugin this$0, boolean $partialResults, String $languageTag, boolean $onDevice) {
        void $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$languageTag, (String)"$languageTag");
        SpeechToTextPlugin $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415 = this$0;
        boolean bl = false;
        Intent intent2 = intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        SpeechToTextPlugin speechToTextPlugin = $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415;
        boolean bl2 = false;
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.debugLog("In RecognizerIntent apply");
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.debugLog("put model");
        Context localContext = $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.pluginContext;
        if (localContext != null) {
            $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("calling_package", localContext.getApplicationInfo().packageName);
        }
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.debugLog("put package");
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("android.speech.extra.PARTIAL_RESULTS", $partialResults);
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.debugLog("put partial");
        if (!Intrinsics.areEqual((Object)$languageTag, (Object)Locale.getDefault().toLanguageTag())) {
            $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("android.speech.extra.LANGUAGE", $languageTag);
            $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415.debugLog("put languageTag");
        }
        if ($onDevice) {
            $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("android.speech.extra.PREFER_OFFLINE", $onDevice);
        }
        $this$setupRecognizerIntent_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.putExtra("android.speech.extra.MAX_RESULTS", 10);
        speechToTextPlugin.recognizerIntent = intent;
    }

    private static final void destroyRecognizer$lambda$18(SpeechToTextPlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SpeechToTextPlugin $this$destroyRecognizer_u24lambda_u2418_u24lambda_u2417 = this$0;
        boolean bl = false;
        $this$destroyRecognizer_u24lambda_u2418_u24lambda_u2417.debugLog("Recognizer destroy");
        SpeechRecognizer speechRecognizer = $this$destroyRecognizer_u24lambda_u2418_u24lambda_u2417.speechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.destroy();
        }
        $this$destroyRecognizer_u24lambda_u2418_u24lambda_u2417.speechRecognizer = null;
    }

    private static final void sendError$lambda$20(SpeechToTextPlugin this$0, JSONObject $speechError) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$speechError, (String)"$speechError");
            SpeechToTextPlugin $this$sendError_u24lambda_u2420_u24lambda_u2419 = this$0;
            boolean bl = false;
            MethodChannel methodChannel = $this$sendError_u24lambda_u2420_u24lambda_u2419.channel;
            if (methodChannel == null) break block0;
            methodChannel.invokeMethod("notifyError", (Object)$speechError.toString());
        }
    }

    private static final void onRmsChanged$lambda$22(SpeechToTextPlugin this$0, float $rmsdB) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpeechToTextPlugin $this$onRmsChanged_u24lambda_u2422_u24lambda_u2421 = this$0;
            boolean bl = false;
            MethodChannel methodChannel = $this$onRmsChanged_u24lambda_u2422_u24lambda_u2421.channel;
            if (methodChannel == null) break block0;
            methodChannel.invokeMethod("soundLevelChange", (Object)Float.valueOf($rmsdB));
        }
    }

    public static final /* synthetic */ boolean access$getDebugLogging$p(SpeechToTextPlugin $this) {
        return $this.debugLogging;
    }

    public static final /* synthetic */ void access$debugLog(SpeechToTextPlugin $this, String msg) {
        $this.debugLog(msg);
    }

    public static final /* synthetic */ void access$setBluetoothHeadset$p(SpeechToTextPlugin $this, BluetoothHeadset bluetoothHeadset) {
        $this.bluetoothHeadset = bluetoothHeadset;
    }

    public static final /* synthetic */ BluetoothHeadset access$getBluetoothHeadset$p(SpeechToTextPlugin $this) {
        return $this.bluetoothHeadset;
    }
}

