/*
 * Decompiled with CFR 0.152.
 */
package com.csdcorp.speech_to_text;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rJ\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/csdcorp/speech_to_text/LanguageDetailsChecker;", "Landroid/content/BroadcastReceiver;", "flutterResult", "Lio/flutter/plugin/common/MethodChannel$Result;", "logging", "", "(Lio/flutter/plugin/common/MethodChannel$Result;Z)V", "debugLogging", "languagePreference", "", "logTag", "result", "supportedLanguages", "", "buildIdNameForLocale", "locale", "Ljava/util/Locale;", "createResponse", "", "debugLog", "msg", "onReceive", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "speech_to_text_release"})
public final class LanguageDetailsChecker
extends BroadcastReceiver {
    @NotNull
    private final String logTag;
    @NotNull
    private final MethodChannel.Result result;
    private final boolean debugLogging;
    @Nullable
    private List<String> supportedLanguages;
    @Nullable
    private String languagePreference;

    public LanguageDetailsChecker(@NotNull MethodChannel.Result flutterResult, boolean logging) {
        Intrinsics.checkNotNullParameter((Object)flutterResult, (String)"flutterResult");
        this.logTag = "SpeechToTextPlugin";
        this.result = flutterResult;
        this.debugLogging = logging;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        this.debugLog("Received extra language broadcast");
        Bundle results = this.getResultExtras(true);
        if (results.containsKey("android.speech.extra.LANGUAGE_PREFERENCE")) {
            this.languagePreference = results.getString("android.speech.extra.LANGUAGE_PREFERENCE");
        }
        if (results.containsKey("android.speech.extra.SUPPORTED_LANGUAGES")) {
            this.debugLog("Extra supported languages");
            this.supportedLanguages = results.getStringArrayList("android.speech.extra.SUPPORTED_LANGUAGES");
            this.createResponse(this.supportedLanguages);
        } else {
            this.debugLog("No extra supported languages");
            this.createResponse(new ArrayList());
        }
    }

    public final void createResponse(@Nullable List<String> supportedLanguages) {
        Locale currentLocale = Locale.getDefault();
        ArrayList<String> localeNames = new ArrayList<String>();
        Intrinsics.checkNotNullExpressionValue((Object)currentLocale, (String)"currentLocale");
        localeNames.add(this.buildIdNameForLocale(currentLocale));
        if (supportedLanguages != null) {
            for (String lang : supportedLanguages) {
                if (Intrinsics.areEqual((Object)currentLocale.toLanguageTag(), (Object)lang)) continue;
                Locale locale = Locale.forLanguageTag(lang);
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
                localeNames.add(this.buildIdNameForLocale(locale));
            }
        }
        this.result.success(localeNames);
    }

    private final String buildIdNameForLocale(Locale locale) {
        String string = locale.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.displayName");
        String name = StringsKt.replace$default((String)string, (char)':', (char)' ', (boolean)false, (int)4, null);
        return locale.getLanguage() + '_' + locale.getCountry() + ':' + name;
    }

    private final void debugLog(String msg) {
        if (this.debugLogging) {
            Log.d((String)this.logTag, (String)msg);
        }
    }
}

