/*
 * Decompiled with CFR 0.152.
 */
package com.tundralabs.fluttertts;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import io.flutter.Log;
import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0011\u0018\u0000 z2\u00020\u00012\u00020\u0002:\u0001zB\u0005\u00a2\u0006\u0002\u0010\u0003J&\u00107\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\t082\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\tH\u0002J\u0010\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010B\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010C\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010D\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010E\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0018\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020LH\u0002J\u0012\u0010M\u001a\u00020\t2\b\u0010N\u001a\u0004\u0018\u00010OH\u0002J\u0012\u0010P\u001a\u00020\t2\b\u0010Q\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010R\u001a\u00020\t2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\u000e\u0010S\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u0019J\u0010\u0010U\u001a\u00020<2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020<2\u0006\u0010V\u001a\u00020WH\u0016J\u0018\u0010Y\u001a\u00020<2\u0006\u0010Z\u001a\u00020[2\u0006\u0010=\u001a\u00020\u0012H\u0016J\u000e\u0010\\\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\u0019J\"\u0010]\u001a\u00020<2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100_2\u0006\u0010`\u001a\u00020aJ\b\u0010b\u001a\u00020<H\u0002J\b\u0010c\u001a\u00020<H\u0002J\b\u0010d\u001a\u00020<H\u0002J\u001a\u0010e\u001a\u00020<2\b\u0010f\u001a\u0004\u0018\u00010\u00102\u0006\u0010=\u001a\u00020\u0012H\u0002J\u001a\u0010g\u001a\u00020<2\b\u0010Q\u001a\u0004\u0018\u00010\u00102\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0018\u0010h\u001a\u00020<2\u0006\u0010i\u001a\u00020j2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0010\u0010k\u001a\u00020<2\u0006\u0010l\u001a\u00020jH\u0002J8\u0010m\u001a\u00020<2&\u0010`\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u001005j\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u0010`62\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0018\u0010n\u001a\u00020<2\u0006\u0010o\u001a\u00020j2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0018\u0010p\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00102\u0006\u0010r\u001a\u00020\tH\u0002J\u000e\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020\u0019J\b\u0010u\u001a\u00020<H\u0002J\u000e\u0010v\u001a\u00020<2\u0006\u0010t\u001a\u00020\u0019J \u0010w\u001a\u00020<2\u0006\u0010q\u001a\u00020\u00102\u0006\u0010x\u001a\u00020\u00102\u0006\u0010y\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00104\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001005j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010`6X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/tundralabs/fluttertts/FlutterTtsPlugin;", "Lio/flutter/plugin/common/MethodChannel$MethodCallHandler;", "Lio/flutter/embedding/engine/plugins/FlutterPlugin;", "()V", "audioFocusRequest", "Landroid/media/AudioFocusRequest;", "audioManager", "Landroid/media/AudioManager;", "awaitSpeakCompletion", "", "awaitSynthCompletion", "bundle", "Landroid/os/Bundle;", "context", "Landroid/content/Context;", "currentText", "", "engineResult", "Lio/flutter/plugin/common/MethodChannel$Result;", "firstTimeOnInitListener", "Landroid/speech/tts/TextToSpeech$OnInitListener;", "handler", "Landroid/os/Handler;", "isPaused", "lastProgress", "", "maxSpeechInputLength", "getMaxSpeechInputLength", "()I", "methodChannel", "Lio/flutter/plugin/common/MethodChannel;", "onInitListener", "parcelFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "pauseText", "pendingMethodCalls", "Ljava/util/ArrayList;", "Ljava/lang/Runnable;", "Lkotlin/collections/ArrayList;", "queueMode", "silencems", "speakResult", "speaking", "synth", "synthResult", "tag", "tts", "Landroid/speech/tts/TextToSpeech;", "ttsStatus", "Ljava/lang/Integer;", "utteranceProgressListener", "Landroid/speech/tts/UtteranceProgressListener;", "utterances", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "areLanguagesInstalled", "", "languages", "", "clearVoice", "", "result", "closeParcelFileDescriptor", "isError", "getDefaultEngine", "getDefaultVoice", "getEngines", "getLanguages", "getSpeechRateValidRange", "getVoices", "initInstance", "messenger", "Lio/flutter/plugin/common/BinaryMessenger;", "invokeMethod", "method", "arguments", "", "isLanguageAvailable", "locale", "Ljava/util/Locale;", "isLanguageInstalled", "language", "ismServiceConnectionUsable", "latencyToString", "quality", "onAttachedToEngine", "binding", "Lio/flutter/embedding/engine/plugins/FlutterPlugin$FlutterPluginBinding;", "onDetachedFromEngine", "onMethodCall", "call", "Lio/flutter/plugin/common/MethodCall;", "qualityToString", "readVoiceProperties", "map", "", "voice", "Landroid/speech/tts/Voice;", "releaseAudioFocus", "requestAudioFocus", "setAudioAttributesForNavigation", "setEngine", "engine", "setLanguage", "setPitch", "pitch", "", "setSpeechRate", "rate", "setVoice", "setVolume", "volume", "speak", "text", "focus", "speakCompletion", "success", "stop", "synthCompletion", "synthesizeToFile", "fileName", "isFullPath", "Companion", "flutter_tts_release"})
@SourceDebugExtension(value={"SMAP\nFlutterTtsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlutterTtsPlugin.kt\ncom/tundralabs/fluttertts/FlutterTtsPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,814:1\n1#2:815\n*E\n"})
public final class FlutterTtsPlugin
implements MethodChannel.MethodCallHandler,
FlutterPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Handler handler;
    @Nullable
    private MethodChannel methodChannel;
    @Nullable
    private MethodChannel.Result speakResult;
    @Nullable
    private MethodChannel.Result synthResult;
    private boolean awaitSpeakCompletion;
    private boolean speaking;
    private boolean awaitSynthCompletion;
    private boolean synth;
    @Nullable
    private Context context;
    @Nullable
    private TextToSpeech tts;
    @NotNull
    private final String tag;
    @NotNull
    private final ArrayList<Runnable> pendingMethodCalls = new ArrayList();
    @NotNull
    private final HashMap<String, String> utterances = new HashMap();
    @Nullable
    private Bundle bundle;
    private int silencems;
    private int lastProgress;
    @Nullable
    private String currentText;
    @Nullable
    private String pauseText;
    private boolean isPaused;
    private int queueMode;
    @Nullable
    private Integer ttsStatus;
    @Nullable
    private MethodChannel.Result engineResult;
    @Nullable
    private ParcelFileDescriptor parcelFileDescriptor;
    @Nullable
    private AudioManager audioManager;
    @Nullable
    private AudioFocusRequest audioFocusRequest;
    @NotNull
    private final UtteranceProgressListener utteranceProgressListener = new UtteranceProgressListener(this){
        final /* synthetic */ FlutterTtsPlugin this$0;
        {
            this.this$0 = $receiver;
        }

        public void onStart(@NotNull String utteranceId) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            if (StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "synth.onStart", true);
            } else if (FlutterTtsPlugin.access$isPaused$p(this.this$0)) {
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onContinue", true);
                FlutterTtsPlugin.access$setPaused$p(this.this$0, false);
            } else {
                Log.d((String)FlutterTtsPlugin.access$getTag$p(this.this$0), (String)("Utterance ID has started: " + utteranceId));
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onStart", true);
            }
            if (Build.VERSION.SDK_INT < 26) {
                V v = FlutterTtsPlugin.access$getUtterances$p(this.this$0).get(utteranceId);
                Intrinsics.checkNotNull(v);
                this.onProgress(utteranceId, 0, ((String)v).length());
            }
        }

        public void onDone(@NotNull String utteranceId) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            if (StringsKt.startsWith$default((String)utteranceId, (String)"SIL_", (boolean)false, (int)2, null)) {
                return;
            }
            if (StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                FlutterTtsPlugin.access$closeParcelFileDescriptor(this.this$0, false);
                Log.d((String)FlutterTtsPlugin.access$getTag$p(this.this$0), (String)("Utterance ID has completed: " + utteranceId));
                if (FlutterTtsPlugin.access$getAwaitSynthCompletion$p(this.this$0)) {
                    this.this$0.synthCompletion(1);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "synth.onComplete", true);
            } else {
                Log.d((String)FlutterTtsPlugin.access$getTag$p(this.this$0), (String)("Utterance ID has completed: " + utteranceId));
                if (FlutterTtsPlugin.access$getAwaitSpeakCompletion$p(this.this$0) && FlutterTtsPlugin.access$getQueueMode$p(this.this$0) == 0) {
                    this.this$0.speakCompletion(1);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onComplete", true);
            }
            FlutterTtsPlugin.access$setLastProgress$p(this.this$0, 0);
            FlutterTtsPlugin.access$setPauseText$p(this.this$0, null);
            FlutterTtsPlugin.access$getUtterances$p(this.this$0).remove(utteranceId);
            FlutterTtsPlugin.access$releaseAudioFocus(this.this$0);
        }

        public void onStop(@NotNull String utteranceId, boolean interrupted) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            Log.d((String)FlutterTtsPlugin.access$getTag$p(this.this$0), (String)("Utterance ID has been stopped: " + utteranceId + ". Interrupted: " + interrupted));
            if (FlutterTtsPlugin.access$getAwaitSpeakCompletion$p(this.this$0)) {
                FlutterTtsPlugin.access$setSpeaking$p(this.this$0, false);
            }
            if (FlutterTtsPlugin.access$isPaused$p(this.this$0)) {
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onPause", true);
            } else {
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onCancel", true);
            }
            FlutterTtsPlugin.access$releaseAudioFocus(this.this$0);
        }

        private final void onProgress(String utteranceId, int startAt, int endAt) {
            if (utteranceId != null && !StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                String text = (String)FlutterTtsPlugin.access$getUtterances$p(this.this$0).get(utteranceId);
                HashMap<K, V> data = new HashMap<K, V>();
                ((Map)data).put("text", text);
                ((Map)data).put("start", String.valueOf(startAt));
                ((Map)data).put("end", String.valueOf(endAt));
                Map map = data;
                String string = text;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(startAt, endAt);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                map.put("word", string2);
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onProgress", data);
            }
        }

        public void onRangeStart(@NotNull String utteranceId, int startAt, int endAt, int frame) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            if (!StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                FlutterTtsPlugin.access$setLastProgress$p(this.this$0, startAt);
                super.onRangeStart(utteranceId, startAt, endAt, frame);
                this.onProgress(utteranceId, startAt, endAt);
            }
        }

        @Deprecated(message="")
        public void onError(@NotNull String utteranceId) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            if (StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                FlutterTtsPlugin.access$closeParcelFileDescriptor(this.this$0, true);
                if (FlutterTtsPlugin.access$getAwaitSynthCompletion$p(this.this$0)) {
                    FlutterTtsPlugin.access$setSynth$p(this.this$0, false);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "synth.onError", "Error from TextToSpeech (synth)");
            } else {
                if (FlutterTtsPlugin.access$getAwaitSpeakCompletion$p(this.this$0)) {
                    FlutterTtsPlugin.access$setSpeaking$p(this.this$0, false);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onError", "Error from TextToSpeech (speak)");
            }
            FlutterTtsPlugin.access$releaseAudioFocus(this.this$0);
        }

        public void onError(@NotNull String utteranceId, int errorCode) {
            Intrinsics.checkNotNullParameter((Object)utteranceId, (String)"utteranceId");
            if (StringsKt.startsWith$default((String)utteranceId, (String)"STF_", (boolean)false, (int)2, null)) {
                FlutterTtsPlugin.access$closeParcelFileDescriptor(this.this$0, true);
                if (FlutterTtsPlugin.access$getAwaitSynthCompletion$p(this.this$0)) {
                    FlutterTtsPlugin.access$setSynth$p(this.this$0, false);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "synth.onError", "Error from TextToSpeech (synth) - " + errorCode);
            } else {
                if (FlutterTtsPlugin.access$getAwaitSpeakCompletion$p(this.this$0)) {
                    FlutterTtsPlugin.access$setSpeaking$p(this.this$0, false);
                }
                FlutterTtsPlugin.access$invokeMethod(this.this$0, "speak.onError", "Error from TextToSpeech (speak) - " + errorCode);
            }
        }
    };
    @NotNull
    private final TextToSpeech.OnInitListener onInitListener = arg_0 -> FlutterTtsPlugin.onInitListener$lambda$3(this, arg_0);
    @NotNull
    private final TextToSpeech.OnInitListener firstTimeOnInitListener = arg_0 -> FlutterTtsPlugin.firstTimeOnInitListener$lambda$5(this, arg_0);
    @NotNull
    private static final String SILENCE_PREFIX = "SIL_";
    @NotNull
    private static final String SYNTHESIZE_TO_FILE_PREFIX = "STF_";

    public FlutterTtsPlugin() {
        this.tag = "TTS";
    }

    private final void initInstance(BinaryMessenger messenger, Context context) {
        this.context = context;
        MethodChannel methodChannel = this.methodChannel = new MethodChannel(messenger, "flutter_tts");
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.handler = new Handler(Looper.getMainLooper());
        this.bundle = new Bundle();
        this.tts = new TextToSpeech(context, this.firstTimeOnInitListener);
    }

    public void onAttachedToEngine(@NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        BinaryMessenger binaryMessenger = binding.getBinaryMessenger();
        Intrinsics.checkNotNullExpressionValue((Object)binaryMessenger, (String)"binding.binaryMessenger");
        Context context = binding.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"binding.applicationContext");
        this.initInstance(binaryMessenger, context);
    }

    public void onDetachedFromEngine(@NotNull FlutterPlugin.FlutterPluginBinding binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        this.stop();
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        textToSpeech.shutdown();
        this.context = null;
        MethodChannel methodChannel = this.methodChannel;
        Intrinsics.checkNotNull((Object)methodChannel);
        methodChannel.setMethodCallHandler(null);
        this.methodChannel = null;
    }

    public final void speakCompletion(int success) {
        this.speaking = false;
        Handler handler = this.handler;
        Intrinsics.checkNotNull((Object)handler);
        handler.post(() -> FlutterTtsPlugin.speakCompletion$lambda$0(this, success));
    }

    public final void synthCompletion(int success) {
        this.synth = false;
        Handler handler = this.handler;
        Intrinsics.checkNotNull((Object)handler);
        handler.post(() -> FlutterTtsPlugin.synthCompletion$lambda$1(this, success));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMethodCall(@NotNull MethodCall call, @NotNull MethodChannel.Result result) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.ttsStatus == null) {
                Runnable suspendedCall = () -> FlutterTtsPlugin.onMethodCall$lambda$7$lambda$6(this, call, result);
                this.pendingMethodCalls.add(suspendedCall);
                return;
            }
            Unit $i$a$-synchronized-FlutterTtsPlugin$onMethodCall$3 = Unit.INSTANCE;
        }
        object = call.method;
        if (object != null) {
            int n = -1;
            switch (((String)object).hashCode()) {
                case -550697939: {
                    if (!((String)object).equals("getDefaultEngine")) break;
                    n = 1;
                    break;
                }
                case -200275950: {
                    if (!((String)object).equals("setQueueMode")) break;
                    n = 2;
                    break;
                }
                case 277104199: {
                    if (!((String)object).equals("isLanguageAvailable")) break;
                    n = 3;
                    break;
                }
                case 1040052984: {
                    if (!((String)object).equals("isLanguageInstalled")) break;
                    n = 4;
                    break;
                }
                case 1508723045: {
                    if (!((String)object).equals("getLanguages")) break;
                    n = 5;
                    break;
                }
                case 967798247: {
                    if (!((String)object).equals("getDefaultVoice")) break;
                    n = 6;
                    break;
                }
                case -707999742: {
                    if (!((String)object).equals("awaitSynthCompletion")) break;
                    n = 7;
                    break;
                }
                case -566982085: {
                    if (!((String)object).equals("getEngines")) break;
                    n = 8;
                    break;
                }
                case -1228785901: {
                    if (!((String)object).equals("areLanguagesInstalled")) break;
                    n = 9;
                    break;
                }
                case 1742137472: {
                    if (!((String)object).equals("getMaxSpeechInputLength")) break;
                    n = 10;
                    break;
                }
                case 109641682: {
                    if (!((String)object).equals("speak")) break;
                    n = 11;
                    break;
                }
                case -299299726: {
                    if (!((String)object).equals("setAudioAttributesForNavigation")) break;
                    n = 12;
                    break;
                }
                case 182735172: {
                    if (!((String)object).equals("setEngine")) break;
                    n = 13;
                    break;
                }
                case 771325407: {
                    if (!((String)object).equals("setSilence")) break;
                    n = 14;
                    break;
                }
                case 1087344356: {
                    if (!((String)object).equals("setSpeechRate")) break;
                    n = 15;
                    break;
                }
                case 670514716: {
                    if (!((String)object).equals("setVolume")) break;
                    n = 16;
                    break;
                }
                case -1153981156: {
                    if (!((String)object).equals("setSharedInstance")) break;
                    n = 17;
                    break;
                }
                case 106440182: {
                    if (!((String)object).equals("pause")) break;
                    n = 18;
                    break;
                }
                case 1407099376: {
                    if (!((String)object).equals("setVoice")) break;
                    n = 19;
                    break;
                }
                case 1326839649: {
                    if (!((String)object).equals("synthesizeToFile")) break;
                    n = 20;
                    break;
                }
                case 3540994: {
                    if (!((String)object).equals("stop")) break;
                    n = 21;
                    break;
                }
                case -741268763: {
                    if (!((String)object).equals("clearVoice")) break;
                    n = 22;
                    break;
                }
                case 971982233: {
                    if (!((String)object).equals("getSpeechRateValidRange")) break;
                    n = 23;
                    break;
                }
                case 885024887: {
                    if (!((String)object).equals("getVoices")) break;
                    n = 24;
                    break;
                }
                case 1401390078: {
                    if (!((String)object).equals("setPitch")) break;
                    n = 25;
                    break;
                }
                case -1360770792: {
                    if (!((String)object).equals("awaitSpeakCompletion")) break;
                    n = 26;
                    break;
                }
                case 375730650: {
                    if (!((String)object).equals("setLanguage")) break;
                    n = 27;
                    break;
                }
            }
            switch (n) {
                case 11: {
                    Object object2 = call.argument("text");
                    Intrinsics.checkNotNull((Object)object2);
                    String text = (String)object2;
                    Object object3 = call.argument("focus");
                    Intrinsics.checkNotNull((Object)object3);
                    boolean focus = (Boolean)object3;
                    if (this.pauseText == null) {
                        String string = this.pauseText = text;
                        Intrinsics.checkNotNull((Object)string);
                        this.currentText = string;
                    }
                    if (this.isPaused) {
                        if (Intrinsics.areEqual((Object)this.currentText, (Object)text)) {
                            String string = this.pauseText;
                            Intrinsics.checkNotNull((Object)string);
                            text = string;
                        } else {
                            String string = this.pauseText = text;
                            Intrinsics.checkNotNull((Object)string);
                            this.currentText = string;
                            this.lastProgress = 0;
                        }
                    }
                    if (this.speaking && this.queueMode == 0) {
                        result.success((Object)0);
                        return;
                    }
                    boolean b = this.speak(text, focus);
                    if (!b) {
                        FlutterTtsPlugin flutterTtsPlugin = this;
                        synchronized (flutterTtsPlugin) {
                            boolean bl = false;
                            Runnable suspendedCall = () -> FlutterTtsPlugin.onMethodCall$lambda$9$lambda$8(this, call, result);
                            boolean bl2 = this.pendingMethodCalls.add(suspendedCall);
                            return;
                        }
                    }
                    if (this.awaitSpeakCompletion && this.queueMode == 0) {
                        this.speaking = true;
                        this.speakResult = result;
                        return;
                    }
                    result.success((Object)1);
                    return;
                }
                case 26: {
                    this.awaitSpeakCompletion = Boolean.parseBoolean(call.arguments.toString());
                    result.success((Object)1);
                    return;
                }
                case 7: {
                    this.awaitSynthCompletion = Boolean.parseBoolean(call.arguments.toString());
                    result.success((Object)1);
                    return;
                }
                case 10: {
                    int res = this.getMaxSpeechInputLength();
                    result.success((Object)res);
                    return;
                }
                case 20: {
                    String text = (String)call.argument("text");
                    if (this.synth) {
                        result.success((Object)0);
                        return;
                    }
                    String fileName = (String)call.argument("fileName");
                    Boolean isFullPath = (Boolean)call.argument("isFullPath");
                    String string = text;
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = fileName;
                    Intrinsics.checkNotNull((Object)string2);
                    Boolean bl = isFullPath;
                    Intrinsics.checkNotNull((Object)bl);
                    this.synthesizeToFile(string, string2, bl);
                    if (this.awaitSynthCompletion) {
                        this.synth = true;
                        this.synthResult = result;
                        return;
                    }
                    result.success((Object)1);
                    return;
                }
                case 18: {
                    this.isPaused = true;
                    if (this.pauseText != null) {
                        String string = this.pauseText;
                        Intrinsics.checkNotNull((Object)string);
                        String string3 = string.substring(this.lastProgress);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                        this.pauseText = string3;
                    }
                    this.stop();
                    result.success((Object)1);
                    if (this.speakResult == null) return;
                    MethodChannel.Result result2 = this.speakResult;
                    Intrinsics.checkNotNull((Object)result2);
                    result2.success((Object)0);
                    this.speakResult = null;
                    return;
                }
                case 21: {
                    this.isPaused = false;
                    this.pauseText = null;
                    this.stop();
                    this.lastProgress = 0;
                    result.success((Object)1);
                    if (this.speakResult == null) return;
                    MethodChannel.Result result3 = this.speakResult;
                    Intrinsics.checkNotNull((Object)result3);
                    result3.success((Object)0);
                    this.speakResult = null;
                    return;
                }
                case 13: {
                    String engine = call.arguments.toString();
                    this.setEngine(engine, result);
                    return;
                }
                case 15: {
                    String rate = call.arguments.toString();
                    this.setSpeechRate(Float.parseFloat(rate) * 2.0f);
                    result.success((Object)1);
                    return;
                }
                case 16: {
                    String volume = call.arguments.toString();
                    this.setVolume(Float.parseFloat(volume), result);
                    return;
                }
                case 25: {
                    String pitch = call.arguments.toString();
                    this.setPitch(Float.parseFloat(pitch), result);
                    return;
                }
                case 27: {
                    String language = call.arguments.toString();
                    this.setLanguage(language, result);
                    return;
                }
                case 5: {
                    this.getLanguages(result);
                    return;
                }
                case 24: {
                    this.getVoices(result);
                    return;
                }
                case 23: {
                    this.getSpeechRateValidRange(result);
                    return;
                }
                case 8: {
                    this.getEngines(result);
                    return;
                }
                case 1: {
                    this.getDefaultEngine(result);
                    return;
                }
                case 6: {
                    this.getDefaultVoice(result);
                    return;
                }
                case 19: {
                    HashMap voice;
                    HashMap hashMap = voice = (HashMap)call.arguments();
                    Intrinsics.checkNotNull((Object)hashMap);
                    this.setVoice(hashMap, result);
                    return;
                }
                case 22: {
                    this.clearVoice(result);
                    return;
                }
                case 3: {
                    String language = call.arguments.toString();
                    Locale locale = Locale.forLanguageTag(language);
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(language)");
                    Locale locale2 = locale;
                    result.success((Object)this.isLanguageAvailable(locale2));
                    return;
                }
                case 14: {
                    String silencems = call.arguments.toString();
                    this.silencems = Integer.parseInt(silencems);
                    return;
                }
                case 17: {
                    result.success((Object)1);
                    return;
                }
                case 4: {
                    String language = call.arguments.toString();
                    result.success((Object)this.isLanguageInstalled(language));
                    return;
                }
                case 9: {
                    List languages;
                    List list = languages = (List)call.arguments();
                    Intrinsics.checkNotNull((Object)list);
                    result.success(this.areLanguagesInstalled(list));
                    return;
                }
                case 2: {
                    String queueMode = call.arguments.toString();
                    this.queueMode = Integer.parseInt(queueMode);
                    result.success((Object)1);
                    return;
                }
                case 12: {
                    this.setAudioAttributesForNavigation();
                    result.success((Object)1);
                    return;
                }
            }
        }
        result.notImplemented();
    }

    private final void setSpeechRate(float rate) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        textToSpeech.setSpeechRate(rate);
    }

    private final boolean isLanguageAvailable(Locale locale) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        return textToSpeech.isLanguageAvailable(locale) >= 0;
    }

    private final Map<String, Boolean> areLanguagesInstalled(List<String> languages) {
        Map result = new HashMap();
        for (String language : languages) {
            result.put(language, this.isLanguageInstalled(language));
        }
        return result;
    }

    private final boolean isLanguageInstalled(String language) {
        String string = language;
        Intrinsics.checkNotNull((Object)string);
        Locale locale = Locale.forLanguageTag(string);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(language!!)");
        Locale locale2 = locale;
        if (this.isLanguageAvailable(locale2)) {
            Voice voiceToCheck = null;
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            for (Voice v : textToSpeech.getVoices()) {
                if (!Intrinsics.areEqual((Object)v.getLocale(), (Object)locale2) || v.isNetworkConnectionRequired()) continue;
                voiceToCheck = v;
                break;
            }
            if (voiceToCheck != null) {
                Set set = voiceToCheck.getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"voiceToCheck.features");
                Set features = set;
                return !features.contains("notInstalled");
            }
        }
        return false;
    }

    private final void setEngine(String engine, MethodChannel.Result result) {
        this.ttsStatus = null;
        this.engineResult = result;
        this.tts = new TextToSpeech(this.context, this.onInitListener, engine);
    }

    private final void setLanguage(String language, MethodChannel.Result result) {
        String string = language;
        Intrinsics.checkNotNull((Object)string);
        Locale locale = Locale.forLanguageTag(string);
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(language!!)");
        Locale locale2 = locale;
        if (this.isLanguageAvailable(locale2)) {
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            textToSpeech.setLanguage(locale2);
            result.success((Object)1);
        } else {
            result.success((Object)0);
        }
    }

    private final void setVoice(HashMap<String, String> voice, MethodChannel.Result result) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        for (Voice ttsVoice : textToSpeech.getVoices()) {
            if (!Intrinsics.areEqual((Object)ttsVoice.getName(), (Object)voice.get("name")) || !Intrinsics.areEqual((Object)ttsVoice.getLocale().toLanguageTag(), (Object)voice.get("locale"))) continue;
            TextToSpeech textToSpeech2 = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech2);
            textToSpeech2.setVoice(ttsVoice);
            result.success((Object)1);
            return;
        }
        Log.d((String)this.tag, (String)("Voice name not found: " + voice));
        result.success((Object)0);
    }

    private final void clearVoice(MethodChannel.Result result) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        TextToSpeech textToSpeech2 = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech2);
        textToSpeech.setVoice(textToSpeech2.getDefaultVoice());
        result.success((Object)1);
    }

    private final void setVolume(float volume, MethodChannel.Result result) {
        boolean bl = 0.0f <= volume ? volume <= 1.0f : false;
        if (bl) {
            Bundle bundle = this.bundle;
            Intrinsics.checkNotNull((Object)bundle);
            bundle.putFloat("volume", volume);
            result.success((Object)1);
        } else {
            Log.d((String)this.tag, (String)("Invalid volume " + volume + " value - Range is from 0.0 to 1.0"));
            result.success((Object)0);
        }
    }

    private final void setPitch(float pitch, MethodChannel.Result result) {
        boolean bl = 0.5f <= pitch ? pitch <= 2.0f : false;
        if (bl) {
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            textToSpeech.setPitch(pitch);
            result.success((Object)1);
        } else {
            Log.d((String)this.tag, (String)("Invalid pitch " + pitch + " value - Range is from 0.5 to 2.0"));
            result.success((Object)0);
        }
    }

    private final void getVoices(MethodChannel.Result result) {
        ArrayList voices = new ArrayList();
        try {
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            for (Voice voice : textToSpeech.getVoices()) {
                HashMap voiceMap = new HashMap();
                Map map = voiceMap;
                Intrinsics.checkNotNullExpressionValue((Object)voice, (String)"voice");
                this.readVoiceProperties(map, voice);
                voices.add(voiceMap);
            }
            result.success(voices);
        }
        catch (NullPointerException e) {
            Log.d((String)this.tag, (String)("getVoices: " + e.getMessage()));
            result.success(null);
        }
    }

    private final void getLanguages(MethodChannel.Result result) {
        ArrayList<String> locales = new ArrayList<String>();
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                TextToSpeech textToSpeech = this.tts;
                Intrinsics.checkNotNull((Object)textToSpeech);
                for (Locale locale : textToSpeech.getAvailableLanguages()) {
                    locales.add(locale.toLanguageTag());
                }
            } else {
                Locale[] localeArray = Locale.getAvailableLocales();
                Intrinsics.checkNotNullExpressionValue((Object)localeArray, (String)"getAvailableLocales()");
                for (Locale locale : localeArray) {
                    String string = locale.getVariant();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.variant");
                    if (!(((CharSequence)string).length() == 0) || !this.isLanguageAvailable(locale)) continue;
                    locales.add(locale.toLanguageTag());
                }
            }
        }
        catch (MissingResourceException e) {
            Log.d((String)this.tag, (String)("getLanguages: " + e.getMessage()));
        }
        catch (NullPointerException e) {
            Log.d((String)this.tag, (String)("getLanguages: " + e.getMessage()));
        }
        result.success(locales);
    }

    private final void getEngines(MethodChannel.Result result) {
        ArrayList<String> engines = new ArrayList<String>();
        try {
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            for (TextToSpeech.EngineInfo engineInfo : textToSpeech.getEngines()) {
                engines.add(engineInfo.name);
            }
        }
        catch (Exception e) {
            Log.d((String)this.tag, (String)("getEngines: " + e.getMessage()));
        }
        result.success(engines);
    }

    private final void getDefaultEngine(MethodChannel.Result result) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        String defaultEngine = textToSpeech.getDefaultEngine();
        result.success((Object)defaultEngine);
    }

    private final void getDefaultVoice(MethodChannel.Result result) {
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        Voice defaultVoice = textToSpeech.getDefaultVoice();
        HashMap voice = new HashMap();
        if (defaultVoice != null) {
            this.readVoiceProperties(voice, defaultVoice);
        }
        result.success(voice);
    }

    public final void readVoiceProperties(@NotNull Map<String, String> map, @NotNull Voice voice) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)voice, (String)"voice");
        Map<String, String> map2 = map;
        String string = "name";
        String string2 = voice.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"voice.name");
        String string3 = string2;
        map2.put(string, string3);
        map2 = map;
        string = "locale";
        String string4 = voice.getLocale().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"voice.locale.toLanguageTag()");
        string3 = string4;
        map2.put(string, string3);
        map.put("quality", this.qualityToString(voice.getQuality()));
        map.put("latency", this.latencyToString(voice.getLatency()));
        map.put("network_required", voice.isNetworkConnectionRequired() ? "1" : "0");
        map2 = map;
        string = "features";
        Set set = voice.getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"voice.features");
        string3 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\t", null, null, (int)0, null, null, (int)62, null);
        map2.put(string, string3);
    }

    @NotNull
    public final String qualityToString(int quality) {
        String string;
        switch (quality) {
            case 500: {
                string = "very high";
                break;
            }
            case 400: {
                string = "high";
                break;
            }
            case 300: {
                string = "normal";
                break;
            }
            case 200: {
                string = "low";
                break;
            }
            case 100: {
                string = "very low";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    @NotNull
    public final String latencyToString(int quality) {
        String string;
        switch (quality) {
            case 500: {
                string = "very high";
                break;
            }
            case 400: {
                string = "high";
                break;
            }
            case 300: {
                string = "normal";
                break;
            }
            case 200: {
                string = "low";
                break;
            }
            case 100: {
                string = "very low";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    private final void getSpeechRateValidRange(MethodChannel.Result result) {
        HashMap data = new HashMap();
        ((Map)data).put("min", "0");
        ((Map)data).put("normal", "0.5");
        ((Map)data).put("max", "1.5");
        ((Map)data).put("platform", "android");
        result.success(data);
    }

    private final boolean speak(String text, boolean focus) {
        boolean bl;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uuid = string;
        ((Map)this.utterances).put(uuid, text);
        if (this.ismServiceConnectionUsable(this.tts)) {
            if (focus) {
                this.requestAudioFocus();
            }
            if (this.silencems > 0) {
                TextToSpeech textToSpeech = this.tts;
                Intrinsics.checkNotNull((Object)textToSpeech);
                textToSpeech.playSilentUtterance((long)this.silencems, 0, SILENCE_PREFIX + uuid);
                TextToSpeech textToSpeech2 = this.tts;
                Intrinsics.checkNotNull((Object)textToSpeech2);
                bl = textToSpeech2.speak((CharSequence)text, 1, this.bundle, uuid) == 0;
            } else {
                TextToSpeech textToSpeech = this.tts;
                Intrinsics.checkNotNull((Object)textToSpeech);
                bl = textToSpeech.speak((CharSequence)text, this.queueMode, this.bundle, uuid) == 0;
            }
        } else {
            this.ttsStatus = null;
            this.tts = new TextToSpeech(this.context, this.onInitListener);
            bl = false;
        }
        return bl;
    }

    private final void stop() {
        if (this.awaitSynthCompletion) {
            this.synth = false;
        }
        if (this.awaitSpeakCompletion) {
            this.speaking = false;
        }
        TextToSpeech textToSpeech = this.tts;
        Intrinsics.checkNotNull((Object)textToSpeech);
        textToSpeech.stop();
    }

    private final int getMaxSpeechInputLength() {
        return TextToSpeech.getMaxSpeechInputLength();
    }

    private final void closeParcelFileDescriptor(boolean isError) {
        if (this.parcelFileDescriptor != null) {
            if (isError) {
                ParcelFileDescriptor parcelFileDescriptor = this.parcelFileDescriptor;
                Intrinsics.checkNotNull((Object)parcelFileDescriptor);
                parcelFileDescriptor.closeWithError("Error synthesizing TTS to file");
            } else {
                ParcelFileDescriptor parcelFileDescriptor = this.parcelFileDescriptor;
                Intrinsics.checkNotNull((Object)parcelFileDescriptor);
                parcelFileDescriptor.close();
            }
        }
    }

    private final void synthesizeToFile(String text, String fileName, boolean isFullPath) {
        int result;
        int n;
        String fullPath = null;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uuid = string;
        Bundle bundle = this.bundle;
        Intrinsics.checkNotNull((Object)bundle);
        bundle.putString("utteranceId", SYNTHESIZE_TO_FILE_PREFIX + uuid);
        if (isFullPath) {
            File file = new File(fileName);
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            fullPath = string2;
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            CharSequence charSequence = text;
            Bundle bundle2 = this.bundle;
            Intrinsics.checkNotNull((Object)bundle2);
            n = textToSpeech.synthesizeToFile(charSequence, bundle2, file, SYNTHESIZE_TO_FILE_PREFIX + uuid);
        } else if (Build.VERSION.SDK_INT >= 30) {
            ParcelFileDescriptor parcelFileDescriptor;
            ContentValues contentValues;
            Context context = this.context;
            ContentResolver resolver = context != null ? context.getContentResolver() : null;
            ContentValues $this$synthesizeToFile_u24lambda_u2410 = contentValues = new ContentValues();
            boolean bl = false;
            $this$synthesizeToFile_u24lambda_u2410.put("_display_name", fileName);
            $this$synthesizeToFile_u24lambda_u2410.put("mime_type", "audio/wav");
            $this$synthesizeToFile_u24lambda_u2410.put("relative_path", Environment.DIRECTORY_MUSIC);
            ContentValues contentValues2 = contentValues;
            ContentResolver contentResolver = resolver;
            Uri uri = contentResolver != null ? contentResolver.insert(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, contentValues2) : null;
            ContentResolver contentResolver2 = resolver;
            if (contentResolver2 != null) {
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                parcelFileDescriptor = contentResolver2.openFileDescriptor(uri2, "rw");
            } else {
                parcelFileDescriptor = null;
            }
            this.parcelFileDescriptor = parcelFileDescriptor;
            Uri uri3 = uri;
            fullPath = (uri3 != null ? uri3.getPath() : null) + File.separatorChar + fileName;
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            CharSequence charSequence = text;
            Bundle bundle3 = this.bundle;
            Intrinsics.checkNotNull((Object)bundle3);
            ParcelFileDescriptor parcelFileDescriptor2 = this.parcelFileDescriptor;
            Intrinsics.checkNotNull((Object)parcelFileDescriptor2);
            n = textToSpeech.synthesizeToFile(charSequence, bundle3, parcelFileDescriptor2, SYNTHESIZE_TO_FILE_PREFIX + uuid);
        } else {
            File musicDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MUSIC);
            File file = new File(musicDir, fileName);
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
            fullPath = string3;
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            CharSequence charSequence = text;
            Bundle bundle4 = this.bundle;
            Intrinsics.checkNotNull((Object)bundle4);
            n = result = textToSpeech.synthesizeToFile(charSequence, bundle4, file, SYNTHESIZE_TO_FILE_PREFIX + uuid);
        }
        if (result == 0) {
            Log.d((String)this.tag, (String)("Successfully created file : " + fullPath));
        } else {
            Log.d((String)this.tag, (String)("Failed creating file : " + fullPath));
        }
    }

    private final void invokeMethod(String method, Object arguments) {
        Handler handler = this.handler;
        Intrinsics.checkNotNull((Object)handler);
        handler.post(() -> FlutterTtsPlugin.invokeMethod$lambda$11(this, method, arguments));
    }

    private final boolean ismServiceConnectionUsable(TextToSpeech tts) {
        boolean isBindConnection = true;
        if (tts == null) {
            return false;
        }
        Field[] fieldArray = tts.getClass().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"tts.javaClass.declaredFields");
        Field[] fields = fieldArray;
        int n = fields.length;
        for (int j = 0; j < n; ++j) {
            fields[j].setAccessible(true);
            if (!Intrinsics.areEqual((Object)"mServiceConnection", (Object)fields[j].getName()) || !Intrinsics.areEqual((Object)"android.speech.tts.TextToSpeech$Connection", (Object)fields[j].getType().getName())) continue;
            try {
                if (fields[j].get(tts) != null) continue;
                isBindConnection = false;
                Log.e((String)this.tag, (String)"*******TTS -> mServiceConnection == null*******");
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isBindConnection;
    }

    private final void setAudioAttributesForNavigation() {
        if (this.tts != null) {
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(12).setContentType(1).build();
            TextToSpeech textToSpeech = this.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            textToSpeech.setAudioAttributes(audioAttributes);
        }
    }

    private final void requestAudioFocus() {
        block1: {
            block0: {
                Context context = this.context;
                Object object = context != null ? context.getSystemService("audio") : null;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
                this.audioManager = (AudioManager)object;
                if (Build.VERSION.SDK_INT < 26) break block0;
                this.audioFocusRequest = new AudioFocusRequest.Builder(3).setOnAudioFocusChangeListener(FlutterTtsPlugin::requestAudioFocus$lambda$12).build();
                AudioManager audioManager = this.audioManager;
                if (audioManager == null) break block1;
                AudioFocusRequest audioFocusRequest = this.audioFocusRequest;
                Intrinsics.checkNotNull((Object)audioFocusRequest);
                audioManager.requestAudioFocus(audioFocusRequest);
                break block1;
            }
            AudioManager audioManager = this.audioManager;
            if (audioManager == null) break block1;
            audioManager.requestAudioFocus(null, 3, 3);
        }
    }

    private final void releaseAudioFocus() {
        block2: {
            block1: {
                if (Build.VERSION.SDK_INT < 26) break block1;
                AudioFocusRequest audioFocusRequest = this.audioFocusRequest;
                if (audioFocusRequest == null) break block2;
                AudioFocusRequest it = audioFocusRequest;
                boolean bl = false;
                AudioManager audioManager = this.audioManager;
                if (audioManager != null) {
                    audioManager.abandonAudioFocusRequest(it);
                }
                break block2;
            }
            AudioManager audioManager = this.audioManager;
            if (audioManager == null) break block2;
            audioManager.abandonAudioFocus(null);
        }
    }

    private static final void speakCompletion$lambda$0(FlutterTtsPlugin this$0, int $success) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MethodChannel.Result result = this$0.speakResult;
        if (result != null) {
            result.success((Object)$success);
        }
        this$0.speakResult = null;
    }

    private static final void synthCompletion$lambda$1(FlutterTtsPlugin this$0, int $success) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MethodChannel.Result result = this$0.synthResult;
        if (result != null) {
            result.success((Object)$success);
        }
        this$0.synthResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onInitListener$lambda$3(FlutterTtsPlugin this$0, int status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FlutterTtsPlugin flutterTtsPlugin = this$0;
        synchronized (flutterTtsPlugin) {
            boolean bl = false;
            this$0.ttsStatus = status;
            for (Runnable call : this$0.pendingMethodCalls) {
                call.run();
            }
            this$0.pendingMethodCalls.clear();
            Unit unit = Unit.INSTANCE;
        }
        if (status == 0) {
            TextToSpeech textToSpeech = this$0.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            textToSpeech.setOnUtteranceProgressListener(this$0.utteranceProgressListener);
            try {
                TextToSpeech textToSpeech2 = this$0.tts;
                Intrinsics.checkNotNull((Object)textToSpeech2);
                Locale locale = textToSpeech2.getDefaultVoice().getLocale();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"tts!!.defaultVoice.locale");
                Locale locale2 = locale;
                if (this$0.isLanguageAvailable(locale2)) {
                    TextToSpeech textToSpeech3 = this$0.tts;
                    Intrinsics.checkNotNull((Object)textToSpeech3);
                    textToSpeech3.setLanguage(locale2);
                }
            }
            catch (NullPointerException e) {
                Log.e((String)this$0.tag, (String)("getDefaultLocale: " + e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this$0.tag, (String)("getDefaultLocale: " + e.getMessage()));
            }
            MethodChannel.Result result = this$0.engineResult;
            Intrinsics.checkNotNull((Object)result);
            result.success((Object)1);
        } else {
            MethodChannel.Result result = this$0.engineResult;
            Intrinsics.checkNotNull((Object)result);
            result.error("TtsError", "Failed to initialize TextToSpeech with status: " + status, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void firstTimeOnInitListener$lambda$5(FlutterTtsPlugin this$0, int status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FlutterTtsPlugin flutterTtsPlugin = this$0;
        synchronized (flutterTtsPlugin) {
            boolean bl = false;
            this$0.ttsStatus = status;
            for (Runnable call : this$0.pendingMethodCalls) {
                call.run();
            }
            this$0.pendingMethodCalls.clear();
            Unit unit = Unit.INSTANCE;
        }
        if (status == 0) {
            TextToSpeech textToSpeech = this$0.tts;
            Intrinsics.checkNotNull((Object)textToSpeech);
            textToSpeech.setOnUtteranceProgressListener(this$0.utteranceProgressListener);
            try {
                TextToSpeech textToSpeech2 = this$0.tts;
                Intrinsics.checkNotNull((Object)textToSpeech2);
                Locale locale = textToSpeech2.getDefaultVoice().getLocale();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"tts!!.defaultVoice.locale");
                Locale locale2 = locale;
                if (this$0.isLanguageAvailable(locale2)) {
                    TextToSpeech textToSpeech3 = this$0.tts;
                    Intrinsics.checkNotNull((Object)textToSpeech3);
                    textToSpeech3.setLanguage(locale2);
                }
            }
            catch (NullPointerException e) {
                Log.e((String)this$0.tag, (String)("getDefaultLocale: " + e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this$0.tag, (String)("getDefaultLocale: " + e.getMessage()));
            }
        } else {
            Log.e((String)this$0.tag, (String)("Failed to initialize TextToSpeech with status: " + status));
        }
    }

    private static final void onMethodCall$lambda$7$lambda$6(FlutterTtsPlugin this$0, MethodCall $call, MethodChannel.Result $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        this$0.onMethodCall($call, $result);
    }

    private static final void onMethodCall$lambda$9$lambda$8(FlutterTtsPlugin this$0, MethodCall $call, MethodChannel.Result $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$call, (String)"$call");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        this$0.onMethodCall($call, $result);
    }

    private static final void invokeMethod$lambda$11(FlutterTtsPlugin this$0, String $method, Object $arguments) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$arguments, (String)"$arguments");
        if (this$0.methodChannel != null) {
            MethodChannel methodChannel = this$0.methodChannel;
            Intrinsics.checkNotNull((Object)methodChannel);
            methodChannel.invokeMethod($method, $arguments);
        }
    }

    private static final void requestAudioFocus$lambda$12(int it) {
    }

    public static final /* synthetic */ void access$invokeMethod(FlutterTtsPlugin $this, String method, Object arguments) {
        $this.invokeMethod(method, arguments);
    }

    public static final /* synthetic */ boolean access$isPaused$p(FlutterTtsPlugin $this) {
        return $this.isPaused;
    }

    public static final /* synthetic */ void access$setPaused$p(FlutterTtsPlugin $this, boolean bl) {
        $this.isPaused = bl;
    }

    public static final /* synthetic */ String access$getTag$p(FlutterTtsPlugin $this) {
        return $this.tag;
    }

    public static final /* synthetic */ HashMap access$getUtterances$p(FlutterTtsPlugin $this) {
        return $this.utterances;
    }

    public static final /* synthetic */ void access$closeParcelFileDescriptor(FlutterTtsPlugin $this, boolean isError) {
        $this.closeParcelFileDescriptor(isError);
    }

    public static final /* synthetic */ boolean access$getAwaitSynthCompletion$p(FlutterTtsPlugin $this) {
        return $this.awaitSynthCompletion;
    }

    public static final /* synthetic */ boolean access$getAwaitSpeakCompletion$p(FlutterTtsPlugin $this) {
        return $this.awaitSpeakCompletion;
    }

    public static final /* synthetic */ int access$getQueueMode$p(FlutterTtsPlugin $this) {
        return $this.queueMode;
    }

    public static final /* synthetic */ void access$setLastProgress$p(FlutterTtsPlugin $this, int n) {
        $this.lastProgress = n;
    }

    public static final /* synthetic */ void access$setPauseText$p(FlutterTtsPlugin $this, String string) {
        $this.pauseText = string;
    }

    public static final /* synthetic */ void access$releaseAudioFocus(FlutterTtsPlugin $this) {
        $this.releaseAudioFocus();
    }

    public static final /* synthetic */ void access$setSpeaking$p(FlutterTtsPlugin $this, boolean bl) {
        $this.speaking = bl;
    }

    public static final /* synthetic */ void access$setSynth$p(FlutterTtsPlugin $this, boolean bl) {
        $this.synth = bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tundralabs/fluttertts/FlutterTtsPlugin$Companion;", "", "()V", "SILENCE_PREFIX", "", "SYNTHESIZE_TO_FILE_PREFIX", "flutter_tts_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

